// brackets.java
// stacks used to check matching brackets
// to run this program: C>java bracketsApp
import java.io.*;                 // operacje wejcia-wyjcia
////////////////////////////////////////////////////////////////
class StackX
   {
   private int maxSize;
   private char[] stackArray;
   private int top;
//--------------------------------------------------------------
   public StackX(int s)       // konstruktor
      {
      maxSize = s;
      stackArray = new char[maxSize];
      top = -1;
      }
//--------------------------------------------------------------
   public void push(char j)  // odkada element na stos
      {
      stackArray[++top] = j;
      }
//--------------------------------------------------------------
   public char pop()         // zdejmuje element ze stosu
      {
      return stackArray[top--];
      }
//--------------------------------------------------------------
   public char peek()        // podglda element na szczycie stosu
      {
      return stackArray[top];
      }
//--------------------------------------------------------------
   public boolean isEmpty()    // zwraca true jeeli stos jest pusty
      {
      return (top == -1);
      }
//--------------------------------------------------------------
   }  // koniec klasy StackX
////////////////////////////////////////////////////////////////
class BracketChecker
   {
   private String input;                   // napis wejciowy
//--------------------------------------------------------------
   public BracketChecker(String in)        // konstruktor
      { input = in; }
//--------------------------------------------------------------
   public void check()
      {
      int stackSize = input.length();      // pobieramy rozmiar napisu
      StackX theStack = new StackX(stackSize);  // tworzymy stos

      for(int j=0; j<input.length(); j++)  // pobieramy kolejne znaki
         {
         char ch = input.charAt(j);        // pobieramy znak
         switch(ch)
            {
            case '{':                      // nawiasy otwierajce...
            case '[':
            case '(':
               theStack.push(ch);          // ...odkadamy na stosie
               break;

            case '}':                      // nawiasy zamykajce
            case ']':
            case ')':
               if( !theStack.isEmpty() )   // jeeli stos niepusty...
                  {
                  char chx = theStack.pop();  // ...zdejmujemy i sprawdzamy
                  if( (ch=='}' && chx!='{') ||
                      (ch==']' && chx!='[') ||
                      (ch==')' && chx!='(') )
                     System.out.println("Bd: "+ch+" na pozycji "+j);
                  }
               else                        // przedwczenie pusty
                  System.out.println("Bd: "+ch+" na pozycji "+j);
               break;
            default:    // ignorujemy pozostae znaki
               break;
            }  // koniec instrukcji switch
         }  // koniec ptli for
      // wszystkie znaki zostay wczytane
      if( !theStack.isEmpty() )
         System.out.println("Bd: brak nawiasu zamykajcego");
      }  // koniec check()
//--------------------------------------------------------------
   }  // koniec klasy BracketChecker
////////////////////////////////////////////////////////////////
class BracketsApp
   {
   public static void main(String[] args) throws IOException
      {
      String input;
      while(true)
         {
         System.out.print(
                      "Wprowad napis zawierajcy nawiasy: ");
         System.out.flush();
         input = getString();     // wczytujemy napis z klawiatury
         if( input.equals("") )   // koniec jeeli sam [Enter]
            break;
                                  // tworzymy obiekt BracketChecker
         BracketChecker theChecker = new BracketChecker(input);
         theChecker.check();      // sprawdzamy nawiasy
         }  // koniec ptli while
      }  // koniec main()
//--------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//--------------------------------------------------------------
   }  // koniec klasy BracketsApp
////////////////////////////////////////////////////////////////
